/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverest;

import com.ibm.hwmca.base.saverest.CustomizableData;
import com.ibm.hwmca.base.saverest.CustomizableFileData;
import com.ibm.hwmca.base.saverest.SaveRestoreData;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BaseSaveRestoreImpl
implements SaveRestoreData {
    protected Map customizableItems;
    protected String saveRestoreFileName;
    protected String TRACE_MASKT = "XSRDBAST";
    protected String TRACE_MASKF = "XSRDBASF";
    protected String TRACE_MASKD = "XSRDBASD";

    public BaseSaveRestoreImpl() {
        try {
            this.saveRestoreFileName = BaseFileControl.getFilePath("basesaverestore.ini") + "basesaverestore.ini";
        }
        catch (HException he) {
            Trace.trace(this.TRACE_MASKF, "Error in getting file path");
            this.saveRestoreFileName = "basesaverestore.ini";
        }
        this.customizableItems = new HashMap();
    }

    public void prepare() {
        Trace.trace(this.TRACE_MASKT, "-> prepare()");
        try {
            String s;
            File f = new File(this.saveRestoreFileName);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            while ((s = br.readLine()) != null) {
                if ((s = s.trim()).length() <= 0 || s.startsWith("#")) continue;
                try {
                    CustomizableData cd = (CustomizableData)Class.forName(s).newInstance();
                    this.customizableItems.put(cd.getCustomDataKey(), cd);
                }
                catch (ClassNotFoundException cnfe) {
                    Trace.trace(this.TRACE_MASKT, "Class not found: " + s);
                }
                catch (InstantiationException ie) {
                    Trace.trace(this.TRACE_MASKT, "Instantiation Exception: " + s);
                }
                catch (IllegalAccessException iae) {
                    Trace.trace(this.TRACE_MASKT, "Illegal Access Exception: " + s);
                }
                catch (ClassCastException cce) {
                    Trace.trace(this.TRACE_MASKT, "Class cast exception: " + s);
                }
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Trace.trace(this.TRACE_MASKT, "<- prepare() ");
    }

    public CustomizableData[] getSaveableItems() {
        CustomizableData[] customizableData = new CustomizableData[this.customizableItems.size()];
        int i = 0;
        Iterator iterator = this.customizableItems.keySet().iterator();
        while (iterator.hasNext()) {
            String customKeyData = (String)iterator.next();
            customizableData[i] = (CustomizableData)this.customizableItems.get(customKeyData);
            ++i;
        }
        return customizableData;
    }

    public Serializable getItem(String customDataKey) {
        Serializable saveableData;
        CustomizableData cd = (CustomizableData)this.customizableItems.get(customDataKey);
        if (cd instanceof CustomizableFileData && (saveableData = ((CustomizableFileData)cd).getSaveableData()) instanceof String[] && saveableData != null) {
            HashMap<String, byte[]> fileMap = new HashMap<String, byte[]>();
            for (int i = 0; i < ((String[])saveableData).length; ++i) {
                File f = new File(((String[])saveableData)[i]);
                try {
                    byte[] contents = new byte[(int)f.length()];
                    if (contents == null || contents.length <= 0) {
                        throw new Exception("Non-existant/Empty file: " + ((String[])saveableData)[i]);
                    }
                    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
                    bis.read(contents, 0, contents.length);
                    bis.close();
                    fileMap.put(((String[])saveableData)[i], contents);
                    Trace.trace(this.TRACE_MASKF, "Stored file data for file: " + ((String[])saveableData)[i]);
                    continue;
                }
                catch (Exception e) {
                    Trace.trace(this.TRACE_MASKF, "Exception reading file: " + ((String[])saveableData)[i]);
                    new FrameworkLog(new FrameworkClassLogInfo(37, "BaseSRImpl"), 6, e).log(FrameworkLogAttributes.INFO_LOG);
                }
            }
            return fileMap;
        }
        return cd.getSaveableData();
    }

    public void setItem(String customDataKey, Serializable obj) {
        CustomizableData cd = (CustomizableData)this.customizableItems.get(customDataKey);
        if (cd instanceof CustomizableFileData && obj instanceof HashMap) {
            ArrayList<String> successes = new ArrayList<String>();
            Iterator iterator = ((HashMap)obj).keySet().iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                Object value = ((HashMap)obj).get(key);
                if (key instanceof String && value instanceof byte[]) {
                    String fileName = (String)key;
                    try {
                        File f = new File(fileName);
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
                        bos.write((byte[])value, 0, ((byte[])value).length);
                        bos.flush();
                        bos.close();
                        Trace.trace(this.TRACE_MASKF, "Success restoring file: " + fileName);
                        successes.add(fileName);
                    }
                    catch (Exception e) {
                        Trace.trace(this.TRACE_MASKF, "Exception writing file: " + fileName);
                        new FrameworkLog(new FrameworkClassLogInfo(37, "BaseSRImpl"), 7, e).log(FrameworkLogAttributes.INFO_LOG);
                    }
                    continue;
                }
                Trace.trace(this.TRACE_MASKF, "Object was not of the proper type: " + key.toString() + ", " + value.toString());
                new FrameworkLog(new FrameworkClassLogInfo(37, "BaseSRImpl"), 7).log(FrameworkLogAttributes.INFO_LOG);
            }
            String[] fileNames = new String[successes.size()];
            fileNames = successes.toArray(fileNames);
            cd.restoreData((Serializable)fileNames);
        } else {
            cd.restoreData(obj);
        }
    }
}

